import {
  Triangular,
  LeftShoulder,
  RightShoulder,
  Trapezoidal,
} from '../MembershipFunctions';

describe('MembershipFunctions', () => {
  describe('Triangular', () => {
    it('should return correct membership values for a triangular function', () => {
      const xValues = [0, 1, 2, 3, 4, 5];
      const result = Triangular(xValues, 0, 2, 4);
      expect(result).toEqual([0, 0.5, 1, 0.5, 0, 0]);
    });

    it('should return all zeros if xValues are outside the triangle range', () => {
      const xValues = [-1, -2, 6, 7];
      const result = Triangular(xValues, 0, 2, 4);
      expect(result).toEqual([0, 0, 0, 0]);
    });
  });

  describe('LeftShoulder', () => {
    it('should return correct membership values for a left shoulder function', () => {
      const xValues = [0, 1, 2, 3, 4, 5];
      const result = LeftShoulder(xValues, 1, 3);
      expect(result).toEqual([1, 1, 0.5, 0, 0, 0]);
    });

    it('should return all ones if xValues are less than or equal to "a"', () => {
      const xValues = [-1, 0, 1];
      const result = LeftShoulder(xValues, 1, 3);
      expect(result).toEqual([1, 1, 1]);
    });
  });

  describe('RightShoulder', () => {
    it('should return correct membership values for a right shoulder function', () => {
      const xValues = [0, 1, 2, 3, 4, 5];
      const result = RightShoulder(xValues, 1, 3);
      expect(result).toEqual([0, 0, 0.5, 1, 1, 1]);
    });

    it('should return all zeros if xValues are less than "a"', () => {
      const xValues = [-1, 0, 0.5];
      const result = RightShoulder(xValues, 1, 3);
      expect(result).toEqual([0, 0, 0]);
    });
  });

  describe('Trapezoidal', () => {
    it('should return correct membership values for a trapezoidal function', () => {
      const xValues = [0, 1, 2, 3, 4, 5];
      const result = Trapezoidal(xValues, 1, 2, 3, 4);
      expect(result).toEqual([0, 0, 1, 1, 0, 0]);
    });

    it('should return all zeros if xValues are outside the trapezoid range', () => {
      const xValues = [-1, 0, 5, 6];
      const result = Trapezoidal(xValues, 1, 2, 3, 4);
      expect(result).toEqual([0, 0, 0, 0]);
    });

    it('should return all ones if xValues are within the flat top of the trapezoid', () => {
      const xValues = [2, 2.5, 3];
      const result = Trapezoidal(xValues, 1, 2, 3, 4);
      expect(result).toEqual([1, 1, 1]);
    });
  });
});
